<?php
// teacher_dashboard.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ---------------------------------------------------------------------
// --- 1. AUTHENTICATION & INITIAL FETCH ---
// ---------------------------------------------------------------------
if(!isset($_SESSION['teacher_id'])){
    header("Location: teacher_login.php");
    exit;
}

$page = $_GET['page'] ?? 'home';
$teacher_name = $_SESSION['teacher_name'] ?? 'Teacher';
$logged_in_id = $_SESSION['teacher_id'];

// --- Database Connection Details ---
$host = "localhost";
$user = "thevkin_schlteachdb"; // Your provided username
$pass = "VK_AutSchlDb";        // Your provided password
$db   = "thevkin_schlteachdb"; // Your provided database name

// Create database connection
$conn = mysqli_connect($host, $user, $pass, $db);

if (!$conn) {
    // If DB connection fails, rely on session data for name and photo (if available)
    error_log("Database Connection failed in teacher_dashboard.php");
}

// ---------------------------------------------------------------------
// --- 2. CRITICAL PHOTO DATABASE REFRESH ---
// ---------------------------------------------------------------------
$db_photo_path = $_SESSION['teacher_photo'] ?? ''; // Start with session photo path as fallback

if ($conn) {
    // Prepare statement to fetch the latest photo and name
    $stmt_photo = $conn->prepare("SELECT photo, first_name, last_name FROM teacher_profiles WHERE id = ?");
    
    // Check if the prepare was successful before binding/executing
    if ($stmt_photo) {
        $stmt_photo->bind_param("s", $logged_in_id);
        $stmt_photo->execute();
        $result_photo = $stmt_photo->get_result();
        $db_data = $result_photo->fetch_assoc();
        $stmt_photo->close();
        
        if ($db_data) {
            // Overwrite the session variable and the teacher name with the latest DB value
            $_SESSION['teacher_photo'] = $db_data['photo'] ?? '';
            $_SESSION['teacher_name'] = $db_data['first_name'] . ' ' . $db_data['last_name'];
            
            $db_photo_path = $_SESSION['teacher_photo'];
            $teacher_name = $_SESSION['teacher_name'];
        }
    }
    // Close connection after fetching data
    mysqli_close($conn); 
}

// ---------------------------------------------------------------------
// --- 3. PHOTO DISPLAY LOGIC (Consistent for all environments) ---
// ---------------------------------------------------------------------
$final_photo_path = '';
$default_photo_path = 'uploads/default.png'; 

// Use the freshly loaded $db_photo_path (or the fallback session data)
$path_to_check = $db_photo_path; 

// Check if the custom path is set AND the file exists
if (!empty($path_to_check) && file_exists($path_to_check)) {
    // Custom photo is set and found
    $final_photo_path = $path_to_check;
    $use_image_tag = true;
} else if (file_exists($default_photo_path)) {
    // Custom photo is missing or path is bad, use the default image
    $final_photo_path = $default_photo_path;
    $use_image_tag = true;
} else {
    // No valid image file found at all, use the generic SVG
    $use_image_tag = false;
}

// Apply cache-buster to the image source ONLY if we are using a file path
if ($use_image_tag) {
    // The cache-buster (?' . time()) is CRITICAL for showing the new photo after profile update
    $display_photo_src = htmlspecialchars($final_photo_path) . '?' . time();
} else {
    $display_photo_src = ''; 
}

// Define valid pages and their corresponding include files
$page_map = [
    'home'              => ['title' => 'Dashboard', 'file' => 'teacher_home.php'],
    'view_students'     => ['title' => 'View Students', 'file' => 'view_students.php'],
    'add_attendance'    => ['title' => 'Add Attendance', 'file' => 'add_attendance.php'],
    'view_attendance'   => ['title' => 'View Attendance', 'file' => 'view_attendance_report.php'],
    'view_attendance_report' => ['title' => 'View Attendance', 'file' => 'view_attendance_report.php'], 
    'add_marks'         => ['title' => 'Add Marks', 'file' => 'add_marks.php'],
    'view_reports'      => ['title' => 'View Reports', 'file' => 'report_card_generator.php'],
    'add_homework'      => ['title' => 'Add Homework', 'file' => 'add_homework.php'],
    'profile'           => ['title' => 'My Profile', 'file' => 'profile.php']
];

$current_page_data = $page_map[$page] ?? $page_map['home'];
$content_file = $current_page_data['file'];
$topbar_title = $current_page_data['title'];

if (!file_exists($content_file) && $page !== 'profile') { 
    // Fallback logic for missing files
    $content_file = 'teacher_home.php'; 
    $topbar_title = 'Dashboard (Default)';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title><?php echo htmlspecialchars($topbar_title); ?> - TheVK School</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
    background: #f3f4f6;
    color: #1f2937;
    /* CRITICAL: Prevent body from creating horizontal scroll for wide content */
    overflow-x: hidden; 
}

.dashboard {
    display: flex;
    min-height: 100vh;
}

/* Sidebar */
.sidebar {
    width: 280px;
    background: linear-gradient(180deg, #1e293b 0%, #0f172a 100%);
    color: white;
    position: fixed;
    height: 100vh;
    overflow-y: auto;
    transition: transform 0.3s ease;
    z-index: 1000;
}

.sidebar-header {
    padding: 24px 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.brand {
    display: flex;
    align-items: center;
    gap: 12px;
}

.brand-logo {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.brand-logo svg {
    width: 24px;
    height: 24px;
}

.brand-text h1 {
    font-size: 18px;
    margin-bottom: 2px;
}

.brand-text p {
    font-size: 12px;
    opacity: 0.7;
}

.teacher-info {
    padding: 20px;
    background: rgba(255, 255, 255, 0.05);
    margin: 20px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.teacher-avatar {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    overflow: hidden; 
}

.teacher-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover; 
}

.teacher-avatar svg {
    width: 24px;
    height: 24px;
}

.teacher-details h3 {
    font-size: 15px;
    margin-bottom: 4px;
}

.teacher-details p {
    font-size: 13px;
    opacity: 0.7;
}

.nav-menu {
    padding: 20px 0;
}

.nav-section {
    margin-bottom: 24px;
}

.nav-section-title {
    padding: 0 20px 8px;
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 1px;
    opacity: 0.5;
}

.nav-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 20px;
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    transition: all 0.2s ease;
    position: relative;
}

.nav-item:hover {
    background: rgba(255, 255, 255, 0.08);
    color: white;
}

.nav-item.active {
    background: rgba(102, 126, 234, 0.2);
    color: white;
    border-left: 3px solid #667eea;
}

.nav-item svg {
    width: 20px;
    height: 20px;
    flex-shrink: 0;
}

.logout-btn {
    margin: 20px;
    padding: 12px 20px;
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #fca5a5;
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    transition: all 0.2s ease;
}

.logout-btn:hover {
    background: rgba(239, 68, 68, 0.2);
}

/* Main Content */
.main-content {
    flex: 1;
    margin-left: 280px;
    transition: margin-left 0.3s ease;
}

.topbar {
    background: white;
    padding: 16px 24px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    justify-content: space-between;
    /* CRITICAL for sticky header */
    position: sticky;
    top: 0;
    z-index: 100;
}

.menu-toggle {
    display: none;
    background: none;
    border: none;
    cursor: pointer;
    padding: 8px;
}

.menu-toggle svg {
    width: 24px;
    height: 24px;
    color: #374151;
}

.topbar-title h2 {
    font-size: 20px;
    color: #1f2937;
}

.topbar-actions {
    display: flex;
    align-items: center;
    gap: 12px;
}

.content-area {
    padding: 24px;
}

.content-frame {
    background: white;
    border-radius: 16px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    /* IMPORTANT: Remove global overflow: hidden here, let the inner wrapper handle it */
    overflow: hidden; 
    min-height: calc(100vh - 120px);
    display: flex; 
    flex-direction: column;
}

/* CRITICAL FIX: The wrapper for the dynamic content that might contain wide tables */
.responsive-table-wrapper {
    /* This allows the table to scroll horizontally inside this div */
    overflow-x: auto; 
    /* Ensures the wrapper itself does not extend beyond its parent's width */
    max-width: 100%; 
    padding: 20px; /* Add some internal padding, or adjust padding in .content-area */
    flex-grow: 1;
}


/* Styles for Iframe content */
.content-frame iframe {
    width: 100%;
    height: 100%;
    border: none;
    display: block;
    min-height: calc(100vh - 168px); 
}


/* Mobile Styles */
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
    }
    
    .sidebar.active {
        transform: translateX(0);
    }
    
    .main-content {
        margin-left: 0;
    }
    
    .menu-toggle {
        display: block;
    }
    
    .topbar {
        padding: 12px 16px;
    }
    
    .topbar-title h2 {
        font-size: 18px;
    }
    
    .content-area {
        padding: 16px;
    }
    
    /* Ensure the content frame adapts on mobile */
    .content-frame {
        min-height: calc(100vh - 100px);
    }
    
    /* Adjust padding for the responsive wrapper on mobile */
    .responsive-table-wrapper {
        padding: 10px;
    }
}

.overlay {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
}

.overlay.active {
    display: block;
}

/* Scrollbar */
.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.05);
}

.sidebar::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.3);
}
</style>
</head>
<body>

<div class="dashboard">
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="brand">
                <div class="brand-logo">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 14l9-5-9-5-9 5 9 5z"/>
                        <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/>
                    </svg>
                </div>
                <div class="brand-text">
                    <h1>TheVK</h1>
                    <p>School Portal</p>
                </div>
            </div>
        </div>
        
        <div class="teacher-info">
            <div class="teacher-avatar" id="teacher-avatar-container">
                <?php if ($use_image_tag): ?>
                    <img src="<?php echo $display_photo_src; ?>" alt="<?php echo htmlspecialchars($teacher_name); ?>'s Profile Photo" id="sidebar-profile-photo">
                <?php else: ?>
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" id="sidebar-profile-svg">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                        <circle cx="12" cy="7" r="4"/>
                    </svg>
                <?php endif; ?>
            </div>
            <div class="teacher-details">
                <h3><?php echo htmlspecialchars($teacher_name); ?></h3>
                <p>Teacher</p>
            </div>
        </div>
        
        <nav class="nav-menu">
            <div class="nav-section">
                <div class="nav-section-title">Main</div>
                <a href="?page=home" class="nav-item <?php echo $page==='home'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <span>Dashboard</span>
                </a>
                <a href="?page=profile" class="nav-item <?php echo $page==='profile'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                        <circle cx="12" cy="7" r="4"/>
                    </svg>
                    <span>My Profile</span>
                </a>
                <a href="?page=view_students" id="view-students-link" class="nav-item <?php echo $page==='view_students'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                    </svg>
                    <span>View Students</span>
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Attendance & Marks</div>
                <a href="?page=add_attendance" class="nav-item <?php echo $page==='add_attendance'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 11l3 3L22 4"/>
                        <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                    </svg>
                    <span>Add Attendance</span>
                </a>
                <a href="?page=view_attendance" class="nav-item <?php echo ($page==='view_attendance' || $page==='view_attendance_report') ?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                        <line x1="16" y1="2" x2="16" y2="6"/>
                        <line x1="8" y1="2" x2="8" y2="6"/>
                        <line x1="3" y1="10" x2="21" y2="10"/>
                        <polyline points="12 15 14 17 18 13"/>
                    </svg>
                    <span>View Attendance</span>
                </a>
                <a href="?page=add_marks" class="nav-item <?php echo $page==='add_marks'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                        <polyline points="10 9 9 9 8 9"/>
                    </svg>
                    <span>Add Marks</span>
                </a>
                <a href="?page=view_reports" class="nav-item <?php echo $page==='view_reports'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <span>View Reports</span>
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Homework</div>
                <a href="?page=add_homework" class="nav-item <?php echo $page==='add_homework'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 20h9"/>
                        <path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"/>
                    </svg>
                    <span>Add Homework</span>
                </a>
            </div>
            
            
        </nav>
        
        <button class="logout-btn" onclick="if(confirm('Are you sure you want to logout?')) window.location.href='logout_teacher.php'">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="20" height="20">
                <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
                <polyline points="16 17 21 12 16 7"/>
                <line x1="21" y1="12" x2="9" y2="12"/>
            </svg>
            Logout
        </button>
    </aside>
    
    <div class="overlay" id="overlay" onclick="closeSidebar()"></div>
    
    <main class="main-content">
        <div class="topbar">
            <button class="menu-toggle" onclick="toggleSidebar()">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="12" x2="21" y2="12"/>
                    <line x1="3" y1="6" x2="21" y2="6"/>
                    <line x1="3" y1="18" x2="21" y2="18"/>
                </svg>
            </button>
            <div class="topbar-title">
                <h2><?php echo htmlspecialchars($topbar_title); ?></h2>
            </div>
            <div class="topbar-actions">
            </div>
        </div>
        
        <div class="content-area">
            <div class="content-frame">
                
                <div class="responsive-table-wrapper"> <?php
                    // --- Dynamic Content Inclusion ---
                    if ($page === 'profile') {
                        // Load the profile.php inside an iframe for isolation
                        echo '<iframe src="profile.php" id="content-iframe" name="content-iframe"></iframe>';
                    } else {
                        // Include other dynamic content directly
                        // IMPORTANT: The included file MUST NOT contain <html>, <head>, or <body> tags.
                        include $content_file;  
                    }
                    ?>
                </div>
            </div>
        </div>
    </main>
</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');
}

function closeSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    sidebar.classList.remove('active');
    overlay.classList.remove('active');
}

/**
 * Listens for messages posted from the profile.php iframe.
 * The reload forces the dashboard to re-run the PHP logic, which now
 * includes fetching the LATEST photo path from the database.
 */
window.addEventListener('message', function(event) {
    const data = event.data;
    
    // Check the origin if possible (for production safety, but omitted here)
    
    if (data && data.action === 'show_alert') {
        // If the update was successful, reload the page. 
        if (data.type === 'success') {
             // Reloading the page forces the PHP block at the top to re-execute,
             // which runs the DB query for the photo path and uses the cache-buster.
             window.location.reload(); 
        }
    }
    
}, false);

// --- Existing JavaScript logic for URL filters ---

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
};

function updateViewStudentsLink() {
    const link = document.getElementById('view-students-link');
    if (!link) return; 
    
    // Read the current filters from the URL
    const currentAY = getUrlParameter('academic_year_id');
    const currentClass = getUrlParameter('class_id');
    
    let queryString = '?page=view_students';
    // Append them to the link so the filters persist when clicking the sidebar link
    if (currentAY) {
        queryString += '&academic_year_id=' + currentAY;
    }
    if (currentClass) {
        queryString += '&class_id=' + currentClass;
    }
    
    link.href = queryString;
}

document.addEventListener('DOMContentLoaded', function() {
    // Only update the link if we are on the view_students page (to capture current filters)
    if (getUrlParameter('page') === 'view_students') {
        updateViewStudentsLink();
    }
});
</script>

</body>
</html>