<?php
// teacher_login.php
session_start();
ini_set('display_errors',1);
error_reporting(E_ALL);

// 1. Database Configuration (Connecting to the correct DB: thevkin_schlteachdb)
$DB_SERVER = "localhost";
$DB_USER = "thevkin_schlteachdb"; 
$DB_PASS = "VK_AutSchlDb"; 
$DB_NAME = "thevkin_schlteachdb"; 

// Establish connection to the TEACHER database
$conn = @mysqli_connect($DB_SERVER, $DB_USER, $DB_PASS, $DB_NAME);

if(!$conn) {
    // Fatal error if connection fails
    die("Database Connection Error: " . mysqli_connect_error());
}

$error = "";
if($_SERVER['REQUEST_METHOD']==='POST'){
    
    // 2. Trim input to handle whitespace errors
    $username = trim($_POST['username'] ?? ''); 
    $password = trim($_POST['password'] ?? '');
    
    // Input validation
    if (empty($username) || empty($password)) {
        $error = "Please enter both username and password.";
    } else {
        
        // 3. Use a prepared statement to fetch the stored hash and names
        $stmt = $conn->prepare("SELECT id, first_name, last_name, password FROM teacher_profiles WHERE username = ? LIMIT 1");
        
        if ($stmt) {
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if($result && $result->num_rows == 1){
                $t = $result->fetch_assoc();
                
                // CRITICAL FIX: Use password_verify() to compare the input password against the stored hash.
                if(password_verify($password, $t['password'])){
                    // SUCCESS: Set session variables and redirect
                    $_SESSION['teacher_id'] = $t['id'];
                    $_SESSION['teacher_name'] = $t['first_name'].' '.$t['last_name'];
                    
                    // Close DB connection before redirect
                    $stmt->close();
                    mysqli_close($conn); 
                    
                    header("Location: teacher_dashboard.php");
                    exit;
                }
            }
            $stmt->close();
        }
        
        // Login failure
        $error = "Invalid username or password. Please try again.";
    }
}

// Close connection if it wasn't closed by a successful redirect
if (isset($conn) && $conn) {
    mysqli_close($conn);
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Teacher Login - TheVK School</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.login-container {
    width: 100%;
    max-width: 440px;
}

.login-card {
    background: #ffffff;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
}

.login-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 40px 30px;
    text-align: center;
    color: white;
}

.logo {
    width: 70px;
    height: 70px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 15px;
    backdrop-filter: blur(10px);
}

.logo svg {
    width: 36px;
    height: 36px;
}

.login-header h1 {
    font-size: 26px;
    margin-bottom: 5px;
}

.login-header p {
    font-size: 14px;
    opacity: 0.9;
}

.login-body {
    padding: 40px 30px;
}

.form-group {
    margin-bottom: 24px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.input-wrapper {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: #9ca3af;
}

.form-control {
    width: 100%;
    padding: 14px 16px 14px 48px;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    font-size: 15px;
    transition: all 0.3s ease;
    font-family: 'Inter', sans-serif;
}

.form-control:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.btn-login {
    width: 100%;
    padding: 16px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 12px;
    font-size: 16px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
}

.btn-login:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
}

.btn-login:active {
    transform: translateY(0);
}

.error-message {
    background: #fee2e2;
    color: #dc2626;
    padding: 14px 16px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 10px;
    font-size: 14px;
    border: 1px solid #fecaca;
}

.error-icon {
    flex-shrink: 0;
}

.login-footer {
    text-align: center;
    padding: 20px 30px 30px;
    color: #6b7280;
    font-size: 13px;
}

@media (max-width: 480px) {
    .login-header {
        padding: 30px 20px;
    }
    
    .login-header h1 {
        font-size: 22px;
    }
    
    .login-body {
        padding: 30px 20px;
    }
    
    .logo {
        width: 60px;
        height: 60px;
    }
}
</style>
</head>
<body>

<div class="login-container">
    <div class="login-card">
        <div class="login-header">
            <div class="logo">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 14l9-5-9-5-9 5 9 5z"/>
                    <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/>
                    <path d="M12 14l9-5-9-5-9 5 9 5zm0 0l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14zm-4 6v-7.5l4-2.222"/>
                </svg>
            </div>
            <h1>Teacher Portal</h1>
            <p>TheVK School Management System</p>
        </div>
        
        <div class="login-body">
            <?php if($error): ?>
            <div class="error-message">
                <div class="error-icon">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="12"/>
                        <line x1="12" y1="16" x2="12.01" y2="16"/>
                    </svg>
                </div>
                <div><?php echo htmlspecialchars($error); ?></div>
            </div>
            <?php endif; ?>
            
            <form method="post" autocomplete="off">
                <div class="form-group">
                    <label for="username">Username</label>
                    <div class="input-wrapper">
                        <div class="input-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                                <circle cx="12" cy="7" r="4"/>
                            </svg>
                        </div>
                        <input 
                            type="text" 
                            id="username" 
                            name="username" 
                            class="form-control" 
                            placeholder="Enter your username" 
                            required 
                            autofocus
                        >
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="password">Password</label>
                    <div class="input-wrapper">
                        <div class="input-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                            </svg>
                        </div>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            class="form-control" 
                            placeholder="Enter your password" 
                            required
                        >
                    </div>
                </div>
                
                <button type="submit" class="btn-login">
                    Sign In
                </button>
            </form>
        </div>
        
        <div class="login-footer">
            &copy; 2025 TheVK School. All rights reserved.
        </div>
    </div>
</div>

</body>
</html>